README for oob
==============


What is it ?
------------

`oob` stands for "Online Offline Backup". This is a shell script to backup hosts
online, as if they were offline (and yes, the name is also a nod to a character
from Dragon Ball).

How does it work ?
------------------

Simple: it bind-mounts all the physical mount points (everything currently
mounted that sits in /dev) and then backs them up. This way, you have a backup
of the real contents of the disk and nothing else (no tmpfs, nfs, sys, proc...)
allowing for an easy restoration in case of disaster recovery.

It pulls files over the network with `rsync`, which means that remote hosts
must be accessible to the super user through `ssh` without password for
automatic operation.

The snapshot management part is heavily inspired from `rsnapshot` by Nathan
Rosenquist.


Why are the advantages over rsnaphot ?
--------------------------------------

- oob is implemented in pure POSIX shell, so you can install it on any
  Linux-based system (a NAS for example) and not worry about missing Perl
  modules
- oob doesn't need you to tell it what to backup, it automagically knows how to
  make a complete and reliable backup of your hosts, easy to restore in case of
  disaster recovery
